﻿using System.Collections.Generic;
using System.Web.UI;
using System;

namespace ErrorHandlerLibrary
{
    public class ErrorHandler : ScriptControl
    {
        protected override IEnumerable<ScriptReference> GetScriptReferences()
        {
            yield return new ScriptReference("ErrorHandlerLibrary.ErrorHandler.js", typeof(ErrorHandler).Assembly.FullName);
            yield return new ScriptReference("ErrorHandlerLibrary.StackTrace.js", typeof(ErrorHandler).Assembly.FullName);
        }

        protected override IEnumerable<ScriptDescriptor> GetScriptDescriptors()
        {
            ScriptComponentDescriptor scd = new ScriptComponentDescriptor("ErrorHandler");
            scd.ID = "ErrorHandler";
            yield return scd;
        }

        protected override void OnPreRender(System.EventArgs e)
        {
            base.OnPreRender(e);
            ScriptManager.GetCurrent(this.Page).Services.Add(new ServiceReference("~/ErrorDataService.asmx"));
        }

        protected override void OnInit(System.EventArgs e)
        {
            base.OnInit(e);
            if (Page.Items.Contains(typeof(ErrorHandler)))
            {
                throw new InvalidOperationException("Strona może jednocześnie zawierać tylko jedną kontrolkę typu ErrorHandler.");
            }
            Page.Items.Add(typeof(ErrorHandler), this);
        }
    }
}   